<?php

/**
 * @file
 * Integration with variable.module.
 */


/**
 * Implements hook_variable_info().
 */
function itweak_login_variable_info($options) {
  $variables['itweak_login_username_inpage_prefix'] = array(
    'title' => t('Text before "Username" field on login page', array(), $options),
    'type' => 'string',
    'default_value' => '',
    'description' => t('Content to add before the username field such as instructions or account support contact information (Note this does not appear in login block).', array(), $options),
    'access' => 'administer users',
    'token' => TRUE, // We'll produce tokens automatically for this one
    'group' => 'itweak_login',
    'localize' => TRUE,
  );

  $variables['itweak_login_register_button_name'] = array(
    'title' => t('Name for "Register" button'),
    'type' => 'string',
    'default_value' => '',
    'description' => t('(Only if "Registration option" is set to "Show button") Text to use as "Register" button label.  Leave empty to use the default.'),
    'access' => 'administer users',
    'token' => TRUE, // We'll produce tokens automatically for this one
    'group' => 'itweak_login',
    'localize' => TRUE,
  );
  $variables['itweak_login_register_name'] = array(
    'title' => t('Text for "Create new account" link'),
    'type' => 'string',
    'default_value' => '',
    'description' => t('(Only if "Registration option" is set to "Show link") Text to use in the "Create new account" link.  Leave empty to use the default.'),
    'access' => 'administer users',
    'token' => TRUE, // We'll produce tokens automatically for this one
    'group' => 'itweak_login',
    'localize' => TRUE,
  );
  $variables['itweak_login_recover_button_name'] = array(
    'title' => t('Name for "Reset Password" button'),
    'type' => 'string',
    'default_value' => '',
    'description' => t('(Only if "Password recovery option" is set to "Show button") Text to use as "Reset Password" button label.  Leave empty to use the default.'),
    'access' => 'administer users',
    'token' => TRUE, // We'll produce tokens automatically for this one
    'group' => 'itweak_login',
    'localize' => TRUE,
  );
  $variables['itweak_login_recover_name'] = array(
    'title' => t('Text for "Request new password" link'),
    'type' => 'string',
    'default_value' => '',
    'description' => t('(Only if "Password recovery option" is set to "Show link") Text to use in the "Request new password" link.  Leave empty to use the default.'),
    'access' => 'administer users',
    'token' => TRUE, // We'll produce tokens automatically for this one
    'group' => 'itweak_login',
    'localize' => TRUE,
  );
  $variables['itweak_login_login_button_name'] = array(
    'title' => t('Name for "Log in" button'),
    'type' => 'string',
    'default_value' => '',
    'description' => t('Text to use as "Log in" button label.  Leave empty to use the default.'),
    'access' => 'administer users',
    'token' => TRUE, // We'll produce tokens automatically for this one
    'group' => 'itweak_login',
    'localize' => TRUE,
  );
  $variables['itweak_login_username_label'] = array(
    'title' => t('Label for "Username" field'),
    'type' => 'string',
    'default_value' => '',
    'description' => t('Text to use for the "Username" textfield label. Leave empty to use the default.'),
    'access' => 'administer users',
    'token' => TRUE, // We'll produce tokens automatically for this one
    'group' => 'itweak_login',
    'localize' => TRUE,
  );
  $variables['itweak_login_password_label'] = array(
    'title' => t('Label for "Password" field'),
    'type' => 'string',
    'default_value' => '',
    'description' => t('Text to use for the "Password" textfield label. Leave empty to use the default.'),
    'access' => 'administer users',
    'token' => TRUE, // We'll produce tokens automatically for this one
    'group' => 'itweak_login',
    'localize' => TRUE,
  );

  $variables['itweak_login_register_mode'] = array(
    'title' => t('Registration option'),
    'description' => t('Select control type (link or button) for new user registration.'),
    'type' => 'select',
    'default_value' => 1,
    'options' => array(
//      0 => t('Disable "Create new account" link'),
      1 => t('Show "Create new account" link (Drupal default)'),
      2 => t('Show "Register" button'),
    ),
    'access' => 'administer users',
    'token' => TRUE, // We'll produce tokens automatically for this one
    'group' => 'itweak_login',
    'localize' => FALSE,
  );
  $variables['itweak_login_register_url'] = array(
    'title' => t('URL for "Create new account" link or "Register" button'),
    'description' => t('URL to use in the "Create new account" link or "Register" button.  Leave empty to use the default (user/register).'),
    'type' => 'url',
    'default_value' => '',
    'access' => 'administer users',
    'token' => TRUE, // We'll produce tokens automatically for this one
    'group' => 'itweak_login',
    'localize' => FALSE,
  );
  $variables['itweak_login_recover_url'] = array(
    'title' => t('URL for "Request new password" link or "Reset Password" button'),
    'description' => t('URL to use in the "Request new password" link or "Reset Password" button.  Leave empty to use the default (user/password).'),
    'type' => 'url',
    'default_value' => '',
    'access' => 'administer users',
    'token' => TRUE, // We'll produce tokens automatically for this one
    'group' => 'itweak_login',
    'localize' => FALSE,
  );
  $variables['itweak_login_recover_mode'] = array(
    'title' => t('Pasword recovery option'),
    'description' => t('Select control type (disabled, link or button) for password recovery.'),
    'type' => 'select',
    'default_value' => '',
    'options' => array(
      0 => t('Disable "Request new password" link'),
      1 => t('Show "Request new password" link (Drupal default)'),
      2 => t('Show "Reset Password" button'),
    ),
    'access' => 'administer users',
    'token' => TRUE, // We'll produce tokens automatically for this one
    'group' => 'itweak_login',
    'localize' => FALSE,
  );


  return $variables;
}

/**
 * Implements hook_variable_group_info().
 */
function itweak_login_variable_group_info() {
  $groups['itweak_login'] = array(
    'title' => t('iTweak Login'),
    'description' => t('iTweak Login'),
    'access' => 'administer users',
    'path' => 'admin/config/people/accounts',
  );
  return $groups;
}

