# Jellyfin Integration

A **Service-Oriented Architecture (SOA)** Drupal module for integrating with [Jellyfin](https://jellyfin.org/), the free software media system.

## Features

- **30+ API Methods**: Comprehensive coverage of Jellyfin's REST API
- **AJAX Connection Testing**: Verify your configuration instantly
- **Library Browser**: Demo interface for browsing your media
- **Movie Grid**: Visual display of your movie collection
- **Item Details**: Full metadata display with backdrop images

## Installation

```bash
# Copy to modules directory
cp -r jellyfin_integration /path/to/drupal/web/modules/custom/

# Enable the module
drush en jellyfin_integration
```

## Configuration

1. Navigate to **Configuration → Media → Jellyfin Integration**
2. Enter your Jellyfin server URL (e.g., `http://localhost:8096`)
3. Enter your API key (generate from Jellyfin Dashboard → API Keys)
4. Click **Test Connection** to verify
5. Save configuration

### Docker Note

If running Drupal in Docker, use the internal hostname:
- `http://host.docker.internal:8096` (for Docker Desktop on Mac/Windows)

## Service Usage

The module provides a `jellyfin_integration.client` service for developers:

```php
// Get the service
$jellyfin = \Drupal::service('jellyfin_integration.client');

// Test connection
$info = $jellyfin->getServerInfo();

// Get all movies
$movies = $jellyfin->getMovies(['Limit' => 20]);

// Search library
$results = $jellyfin->search('action');

// Get poster URL
$poster = $jellyfin->getPosterUrl($itemId, 300);
```

## Available Methods

### System Operations
- `testConnection()` - Verify server connectivity
- `getServerInfo()` - Get server information
- `getPublicInfo()` - Get public server info (no auth)
- `getEndpoints()` - Get server endpoints

### User Operations
- `getUsers()` - List all users
- `getUser($userId)` - Get specific user
- `getPublicUsers()` - Get public users

### Library Operations
- `getLibraries()` - List virtual folders/libraries
- `refreshLibrary()` - Trigger library refresh
- `getMediaFolders()` - Get media folders

### Item Operations
- `getItems($params)` - Query items with filters
- `getItem($itemId)` - Get specific item
- `getUserItems($userId, $params)` - Get items for user
- `getMovies($params)` - Get movies
- `getSeries($params)` - Get TV series
- `getEpisodes($params)` - Get episodes
- `getLatestMedia($userId)` - Get recently added
- `getResumeItems($userId)` - Get continue watching
- `getSimilarItems($itemId)` - Get similar items

### Search Operations
- `search($query, $params)` - Search library

### Genre/Category Operations
- `getGenres($params)` - List genres
- `getStudios($params)` - List studios
- `getArtists($params)` - List artists
- `getPersons($params)` - List persons

### Image Operations
- `getImageUrl($itemId, $type, $params)` - Get image URL
- `getPosterUrl($itemId, $maxWidth)` - Get poster URL
- `getBackdropUrl($itemId, $maxWidth)` - Get backdrop URL
- `getThumbnailUrl($itemId, $maxWidth)` - Get thumbnail URL

### Playback Operations
- `getPlaybackInfo($itemId, $userId)` - Get playback info
- `getStreamUrl($itemId, $container)` - Get stream URL

## Requirements

- Drupal 9.4, 10, or 11
- A running Jellyfin server
- API key with appropriate permissions

## License

GPL-2.0-or-later
