<?php

namespace Drupal\json_field_query\Plugin\Field\FieldType;

use Drupal\Core\Field\FieldItemBase;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\TypedData\DataDefinition;

/**
 * Plugin implementation of the 'json_query' field type.
 *
 * @FieldType(
 *   id = "json_query",
 *   label = @Translation("JSON with Query"),
 *   description = @Translation("Stores JSON data with query capabilities."),
 *   default_widget = "json_query_textarea",
 *   default_formatter = "json_query_formatter",
 *   category = "Text"
 * )
 */
class JsonQueryItem extends FieldItemBase {

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties['value'] = DataDefinition::create('string')
      ->setLabel(t('JSON Value'))
      ->setRequired(TRUE);

    return $properties;
  }

  /**
   * {@inheritdoc}
   */
  public static function schema(FieldStorageDefinitionInterface $field_definition) {
    return [
      'columns' => [
        'value' => [
          'type' => 'text',
          'size' => 'big',
          'not null' => FALSE,
        ],
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function isEmpty() {
    $value = $this->get('value')->getValue();
    return $value === NULL || $value === '' || $value === 'null';
  }

  /**
   * {@inheritdoc}
   */
  public static function defaultFieldSettings() {
    return [
      'validate_json' => TRUE,
    ] + parent::defaultFieldSettings();
  }

  /**
   * {@inheritdoc}
   */
  public function fieldSettingsForm(array $form, FormStateInterface $form_state) {
    $element = [];

    $element['validate_json'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Validate JSON on input'),
      '#default_value' => $this->getSetting('validate_json'),
      '#description' => $this->t('Ensure the input is valid JSON.'),
    ];

    return $element;
  }

}