JSON Viewer
===========

The **JSON Viewer** module is a simple and lightweight tool that provides
various ways to display and work with JSON data in Drupal. It includes a
dedicated block for editing and previewing JSON, as well as several field
formatters for displaying JSON from a variety of field types, including
text fields, file fields, and media entity references.

This module offers flexible display options, a variety of color palettes, and
interactive features like expand/collapse, search, and fullscreen viewing.
Administrators can choose a field formatter that best suits their content
structure, ensuring a smooth user experience while displaying structured data.

Ideal for developers, data managers, or any site needing to present structured
JSON data, the JSON Viewer module makes it easy to visualize, validate, and
interact with JSON content directly within the Drupal site.

* * *

### Table of contents

*   [Requirements](#requirements)
*   [Installation](#installation)
*   [Blocks Provided](#blocks-provided)
*   [Field Formatters Provided](#field-formatters-provided)
*   [Configuration](#configuration)
*   [Hooks](#hooks)
*   [Customization](#customization)
*   [Troubleshooting](#troubleshooting)
*   [Maintainers](#maintainers)

* * *

### Requirements

This module requires only Drupal core.

* * *

### Installation

Install as you would normally install a contributed Drupal module.
For more information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

If using Composer:

    composer require drupal/json_viewer

Enable the module using Drush:

    drush en json_viewer

* * *

### Blocks Provided

*   **JSON Previewer** – Provides a flexible block with a full JSON editor
on the left and a live preview on the right. This is ideal for quick editing,
validation, and testing of JSON snippets.
    

* * *

### Field Formatters Provided

The module provides a field formatter for each of the following field types:

*   **JSON Viewer (for Text fields)** – Renders the JSON string directly
from a string, string_long, or text field as a formatted, interactive tree.
It includes built-in validation to handle invalid JSON.
    
*   **JSON File Viewer (for File fields)** – Renders the contents of a JSON
file uploaded to a file field. It checks the file's mime type and handles
potential file errors.
    
*   **JSON Media Viewer (for Entity Reference fields)** – Renders the
contents of a JSON file that is referenced by a Media entity. This provides
a clean way to manage JSON files using the Drupal Media Library.
    

* * *

### Configuration

The module's configuration is managed through the settings of its blocks
and field formatters. You can customize the following options:

*   **Initial JSON Data**: For the JSON Previewer block, you can set the
default JSON content to be displayed.
    
*   **Color Palette**: Choose from a variety of color schemes to style
the JSON tree. This setting is available for both blocks and all field
formatters.
    
*   **Default Expansion Level**: Set the number of levels for the JSON
tree to be expanded by default on page load.
    
*   **Display Controls**: For the JSON Previewer block, you can choose
to show or hide the "Expand All," "Collapse All," "Search," and "Fullscreen"
buttons.
    

* * *

### Hooks

The module provides the following hook for extensibility:

*   **`hook_json_viewer_color_palettes_alter(array &$palettes)`** – Allows 
other modules to add or remove color palettes from the selection options.
    

* * *

### Customization

You can customize the appearance of the JSON viewer by overriding its Twig
templates in your theme.

1.  Identify the template you wish to override:
    
    *   For the JSON Previewer block: json-previewer-block.html.twig
    *   For all JSON Viewer field formatters: json-viewer.html.twig
2.  Copy the template file from the module's `templates/` directory to your
theme's `templates/` directory.
    
3.  Clear the Drupal cache (e.g., `drush cr`) to register the new template.
    
4.  Edit the template file to apply your custom HTML, CSS classes, or modify
the layout as needed.
    

* * *

### Troubleshooting

*   If JSON data is not rendering, ensure the input is valid JSON. The
module includes validation to catch common errors.
    
*   For file or media viewers, ensure the file's mime type is application/json.
    
*   If styles are not loading, clear the Drupal cache and ensure the
json\viewer library is attached correctly.
    

* * *

### Maintainers

*   Sujan Shrestha - [sujan-shrestha](https://www.drupal.org/u/sujan-shrestha)
