<?php

/**
 * @file
 * Hooks provided by the JSON Viewer module.
 */

/**
 * @addtogroup hooks
 * @{
 */

/**
 * Alter the available color palettes for the JSON viewer.
 *
 * This hook allows other modules to add or remove color palettes from the list
 * of options available in the JSON viewer's configuration forms.
 *
 * @param array &$palettes
 *   An associative array of color palette keys (machine names) and their
 *   human-readable names.
 *
 * @code
 *   Example: Add a new palette
 *   $palettes['color-palette-custom'] = t('My Custom Palette');
 *
 *   Example: Modify an existing palette
 *   if (isset($palettes['color-palette-ruby'])) {
 *   $palettes['color-palette-ruby'] = t('Crimson Red');
 *   }
 *
 *   Example: Remove a palette
 *   unset($palettes['color-palette-desert']);
 *
 *   Example usage in a custom module:
 *   function my_module_json_viewer_get_color_palettes_alter(array &$palettes) {
 *   // Add a new palette.
 *   $palettes['color-palette-monochromatic'] = t('Monochromatic');
 *
 *   // Modify the 'Forest' palette.
 *   if (isset($palettes['color-palette-forest'])) {
 *   $palettes['color-palette-forest'] = t('Deep Forest Green');
 *   }
 *
 *   // Remove the 'Vintage' palette.
 *   unset($palettes['color-palette-vintage']);
 *   }
 * @endcode
 */
function hook_json_viewer_color_palettes_alter(array &$palettes) {
}

/**
 * @} End of "addtogroup hooks".
 */
