import React from 'react';
import AuthSection from './AuthSection';

const AuthenticationTab = () => {
  return (
    <div className="layout-row" data-testid="auth-tab">
      <div className="layout-column layout-column--full">
        <div className="panel">
          <div className="gin-layer-wrapper">
            <h3 className="heading">Authentication</h3>

            {/* Authentication info */}
            <div className="form-item">
              <div className="form-item__description">
                The JSON:API Explorer automatically uses your current Drupal session for authentication.
                No additional authentication is required when using this tool.

                The examples below show how to authenticate when accessing the API from external applications.
              </div>
            </div>

            {/* Using the updated AuthSection component */}
            <AuthSection />
          </div>
        </div>
      </div>
    </div>
  );
};

export default AuthenticationTab;