/**
 * Puppeteer configuration for tests.
 * 
 * This configuration is now minimal as most settings are defined in the 
 * test file itself. This follows a more modern approach where test-specific
 * configurations are kept with the tests themselves.
 */

module.exports = {
  launch: {
    headless: process.env.HEADLESS !== 'false' ? 'new' : false,
    args: [
      '--no-sandbox',
      '--disable-setuid-sandbox',
      '--disable-dev-shm-usage',
      '--ignore-certificate-errors',
      '--allow-insecure-localhost'
    ],
    ignoreHTTPSErrors: true,
    devtools: process.env.HEADLESS !== 'false'
  },
  browserContext: 'default',
  exitOnPageError: false,
  server: false
};