/**
 * Jest Configuration for CI environment.
 * 
 * This configuration is used specifically for GitLab CI to run tests
 * with proper JUnit reporting.
 */

module.exports = {
  // Use jsdom as the default test environment
  testEnvironment: 'jsdom',
  
  // Use preset for E2E tests with Puppeteer
  preset: 'jest-puppeteer',
  
  // Find component tests and e2e tests
  testMatch: [
    '<rootDir>/src/**/__tests__/**/*.js?(x)',
    '<rootDir>/src/**/?(*.)+(spec|test).js?(x)',
    '<rootDir>/test/**/?(*.)+(spec|test).js?(x)'
  ],
  
  // Configure coverage
  collectCoverage: true,
  coverageDirectory: 'coverage',
  collectCoverageFrom: [
    'src/**/*.{js,jsx}',
    '!src/index.js',
  ],
  
  // Module handling  
  moduleNameMapper: {
    "\\.(css|less|sass|scss)$": "<rootDir>/__mocks__/styleMock.js",
    "\\.(gif|ttf|eot|svg|png)$": "<rootDir>/__mocks__/fileMock.js"
  },
  
  // Setup test environment
  setupFilesAfterEnv: ['<rootDir>/setupTests.js'],
  
  // Mocks and transformations
  transform: {
    "^.+\\.(js|jsx)$": "babel-jest"
  },
  transformIgnorePatterns: [
    "/node_modules/(?!react-syntax-highlighter|react-json-view).+\\.js$"
  ],
  
  // JUnit reporter configuration for CI
  reporters: [
    'default',
    ['jest-junit', {
      outputDirectory: '.',
      outputName: 'junit.xml',
      classNameTemplate: '{classname}',
      titleTemplate: '{title}',
      ancestorSeparator: ' › ',
      suiteNameTemplate: '{filename}'
    }]
  ]
};