# Contributing to JSON:API Query Builder

Thank you for your interest in contributing to the JSON:API Query Builder module! We welcome contributions of all kinds from anyone.

## Getting Started

Before you begin:

1. Make sure you have a [Drupal.org account](https://www.drupal.org/user/register)
2. Make sure you have [DDEV](https://ddev.com/) installed
3. Familiarize yourself with [Drupal coding standards](https://www.drupal.org/docs/develop/standards)

## Setting Up Your Development Environment

1. Clone the repository:
   ```
   git clone https://git.drupalcode.org/project/jsonapi_query_builder.git
   cd jsonapi_query_builder
   ```

2. Start DDEV and initialize your environment:
   ```
   ddev start
   ddev jqb:init
   ```

   This will compose the codebase, build the React application, install Drupal, and enable the module.

3. Set your Git user information in DDEV:
   ```
   ddev exec git config --global user.name 'Your Name'
   ddev exec git config --global user.email 'your.email@example.com'
   ```

## Development Workflow

1. Create a new branch for your work:
   ```
   git checkout -b your-feature-name
   ```

2. Make your changes

3. Recompile the React application if you made changes to the frontend:
   ```
   ddev jqb:build-js
   ```

4. Run tests to ensure code quality:
   ```
   composer test
   ```

   Or run individual tests:
   ```
   ddev phpcs
   ddev phpstan
   composer phpunit
   composer phpunit-functional
   composer test-js
   ```

5. Commit your changes with clear commit messages

6. Create a merge request on Drupal.org

## PHP Coding Standards

Follow Drupal's coding standards:

- Use proper indentation (2 spaces)
- Follow naming conventions (camelCase for functions/methods, snake_case for variables)
- Add appropriate documentation (@param, @return, etc.)
- Add appropriate use statements and organize them alphabetically
- Use appropriate line lengths (generally 80 characters)

Run PHP_CodeSniffer to check your code:
```
ddev phpcs
```

## JavaScript Coding Standards

For React code:

- Follow the ESLint configuration in the React app
- Use functional components with hooks
- Follow React best practices
- Organize imports
- Use proper JSDoc comments

## Testing

All new features or bug fixes should include tests:

- Unit tests for PHP classes
- Functional tests for UI elements
- Test both success and error cases

## Creating Merge Requests

If you have maintainer access:

1. Push your branch to the repository
2. Create a merge request on GitLab
3. Link to any related issues
4. Wait for code review

## Additional Resources

- [Drupal Coding Standards](https://www.drupal.org/docs/develop/standards)
- [Creating a Drupal.org Issue](https://www.drupal.org/node/73179)
- [Creating a Merge Request](https://www.drupal.org/drupalorg/docs/gitlab-integration/merge-requests)
