# JSON:API Query Builder

A modern, interactive interface for exploring and building Drupal JSON:API requests.

## Introduction

The JSON:API Query Builder provides a user-friendly interface for discovering and testing Drupal's JSON:API endpoints. This module helps developers and site builders construct API requests visually, eliminating the need to manually build complex query strings.

## Features

- Discover entity types and bundles available in your Drupal site
- Visually construct JSON:API queries with all supported parameters:
  - Fields (selective field inclusion)
  - Includes (relationships)
  - Filters (with various operators)
  - Sorting (with direction)
  - Pagination
- Display formatted responses with syntax highlighting
- Copy constructed URLs for use in your code
- Generate cURL commands for testing
- Authentication documentation for API integration
- Request history to easily revisit previous queries
- Bookmark favorite queries for later use
- Support for related entity fields with dot notation
- Copy JSON paths from response for easy reference

## Screenshots

### Field Selection
![Query Builder Interface](images/jsonapi-query-builder-interface.png)

### Filtering
![Fields Selection](images/jsonapi-query-builder-fields.png)

## Requirements

- Drupal 10 or greater
- JSON:API module (core)

## Installation

1. Install via Composer:
   ```
   composer require drupal/jsonapi_query_builder
   ```

2. Enable the module:
   ```
   drush en jsonapi_query_builder
   ```

3. Clear caches:
   ```
   drush cr
   ```

For detailed installation instructions, see [INSTALL.md](INSTALL.md).

## Configuration

No configuration is necessary. The module provides a permission "access jsonapi query builder" that controls who can use the query builder.

## Usage

1. Navigate to the JSON:API Query Builder at:
   `/admin/jsonapi-query-builder`

2. Select an entity type and bundle to begin building your query.

3. Add fields, includes, filters, sorting, and pagination as needed.

4. Click "Execute Request" to see the JSON:API response.

### Building Queries

The JSON:API Query Builder interface has several sections:

1. **Entity Selection**: Choose the entity type and bundle to query
2. **Fields**: Select which fields to include in the response
3. **Includes**: Add related entities to include in the response
4. **Filters**: Define criteria to filter the results
5. **Sort**: Choose fields to sort by and the direction
6. **Pagination**: Set page limits and offsets
7. **URL Display**: Shows the current JSON:API URL
8. **Response**: Displays the formatted JSON response

### Related Entity Fields

When you include relationships, the Query Builder loads schema data for the related entities, making their fields available for selection, filtering, and sorting with dot notation:

- Field selection: `node--article` with included `uid` relationship makes `uid.name` available
- Filtering: Filter by `uid.roles.target_id`
- Sorting: Sort by `uid.created`

### Authentication

The Query Builder uses your current Drupal session for authentication. The Authentication tab provides documentation for external API access, including:

- Using session cookies
- Bearer token authentication
- Code examples in various languages

## Contributing

Contributions are welcome! See [CONTRIBUTING.md](CONTRIBUTING.md).
