# JSON:API Query Builder testing guide

This document explains how to run tests for the JSON:API Query Builder module.

## Types of tests

The module includes several types of tests:

1. **Screenshot tests**: Capture screenshots of the UI for visual verification
2. **End-to-end tests**: Test the full application flow in a real browser

## Running tests

### Prerequisites

- Node.js (v14+)
- Yarn
- Access to a command line

### Setting up

1. Navigate to the React app directory:

```bash
cd /path/to/jsonapi_query_builder/js/react-app
```

2. Install dependencies:

```bash
yarn install
```

### Running screenshot tests

These tests capture screenshots of the UI for documentation and verification:

```bash
yarn test:screenshot
```

This will generate screenshots in the `tests/screenshots` directory.

### Running end-to-end tests

### Using the unified test script

The unified test script provides a simpler, more reliable way to run E2E tests:

```bash
# Run tests against existing Drupal environment
./test.sh

# Create a test environment and run tests
./test.sh --regen=true

# Run tests with visible browser
./test.sh --headless=false
```

The test script handles:
- Checking for and killing orphaned Chrome processes
- Setting up the test environment (when using --regen)
- Proper environment detection
- Screenshot generation
- Detailed logging
- Browser management

### Test Implementation

The tests use a resilient selector strategy that prefers:
1. Element IDs when available (e.g., `#entity-type-select`)
2. Text content for buttons and tabs (e.g., text that includes "Filters")
3. DOM structure and class names as fallbacks

This approach makes tests less brittle to theme changes and UI modifications.

The tests also use dynamic entity type and bundle selection rather than hardcoding values like "node" and "article". This makes the tests resilient to different Drupal installations that might have different entity types available. The tests automatically detect and use the first available entity type and bundle.

### Legacy E2E test approaches

#### Full E2E test environment (Legacy)

The full E2E test setup creates a temporary Drupal environment with the module installed:

```bash
yarn test:e2e:full
```

This command:
1. Creates a temporary Drupal installation in `/tmp`
2. Installs the module with its dependencies
3. Sets up a test user and Drupal instance
4. Runs the E2E tests against this environment
5. Captures screenshots for documentation
6. Cleans up the temporary environment

> **Note**: The unified test script (`./test.sh --regen=true`) is now the recommended approach.

#### Interactive E2E tests (Legacy)

To run E2E tests in a visible browser window (non-headless mode) using the legacy approach:

```bash
TEST_URL=http://your-drupal-site.test yarn test:e2e:interactive
```

This opens a visible Chrome window that you can observe as the test runs.

#### Manual E2E test setup (Legacy)

If you want to run the E2E tests against your existing Drupal site:

1. Ensure the JSON:API Query Builder module is installed and enabled
2. Set the `TEST_URL` environment variable to your Drupal site URL
3. Set `TEST_USERNAME` and `TEST_PASSWORD` for a user with access to the module

```bash
TEST_URL=http://your-drupal-site.test \
TEST_USERNAME=admin \
TEST_PASSWORD=yourpassword \
yarn test:e2e
```

## Troubleshooting

### E2E test failures

If the E2E tests fail:

1. Check browser console logs for errors (visible in interactive mode)
2. Verify the module is correctly installed and enabled
3. Confirm the user has permissions to access the module
4. Check the HTML structure in the saved debug file (`test/page-debug.html`)
5. Review screenshots to see where tests might be failing

### Understanding test structure

The end-to-end tests follow this pattern:

1. **Setup**: Log in to Drupal and navigate to the JSON:API Query Builder
2. **Common Prerequisites**: Select node/article entity type and bundle
3. **UI Interaction**: Click buttons, select options, and interact with widgets
4. **Verification**: Check URL parameters and UI state
5. **Cleanup**: Take screenshots for debugging and close browser

### Selector strategy notes

The tests originally attempted to use `data-testid` attributes for selecting elements, but these attributes aren't appearing in the rendered DOM. This could be due to:

1. The build process stripping these attributes
2. Component props not being passed correctly
3. React configuration settings

As a workaround, the tests now use a combination of:
- Element IDs for form controls
- Text content for buttons and tabs
- DOM structure for related elements

This approach is more resilient but depends on these patterns being maintained.

### Port conflicts

The full E2E test uses port 9888 by default. If this port is in use:

```bash
TEST_PORT=9889 yarn test:e2e:full
```

## Continuous integration

The module includes CI configuration for GitLab CI/CD. Tests will run automatically on each commit to ensure compatibility.
