import React from 'react';
import { Prism as SyntaxHighlighter } from 'react-syntax-highlighter';
import { materialLight } from 'react-syntax-highlighter/dist/esm/styles/prism';

function CurlCommandDisplay({ requestUrl, authToken, onCopy }) {
  const generateCurlCommand = () => {
    if (!requestUrl) return 'No request URL available';

    let command = `curl -X GET "${requestUrl}"`;

    if (authToken) {
      command += ` \\\n  -H "Authorization: Bearer ${authToken}"`;
    }

    command += ` \\\n  -H "Accept: application/vnd.api+json"`;

    return command;
  };

  return (
    <div className="curl-display">
      <div className="form-item__label form-item__label--multiple-value-form" style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center' }}>
        <h4 className="form-item__label" style={{ margin: 0 }}>cURL command for current request</h4>
        <button
          className="button button--small"
          onClick={() => onCopy(generateCurlCommand())}
          disabled={!requestUrl}
          aria-label="Copy cURL command to clipboard"
        >
          Copy
        </button>
      </div>

      <div className="card" style={{ maxHeight: 300, overflow: 'auto', marginBottom: '24px' }}>
        <div className="card__content">
          {!requestUrl ? (
            <div className="form-item__description" style={{ padding: '16px', textAlign: 'center' }}>
              No requests have been made yet
            </div>
          ) : (
            <SyntaxHighlighter
              language="bash"
              style={materialLight}
              wrapLines={true}
              customStyle={{ margin: 0 }}
            >
              {generateCurlCommand()}
            </SyntaxHighlighter>
          )}
        </div>
      </div>
    </div>
  );
}

export default CurlCommandDisplay;
