import React from 'react';

function PageLimitSelector({ page, limit, onPageChange, onLimitChange }) {
  const handlePageChange = (e) => {
    const value = parseInt(e.target.value, 10);
    if (!isNaN(value) && value >= 0) {
      onPageChange(value);
    } else if (e.target.value === '') {
      onPageChange(0);
    }
  };

  const handleLimitChange = (e) => {
    const value = parseInt(e.target.value, 10);
    if (!isNaN(value) && value > 0) {
      if (value > 50) {
        onLimitChange(50);
      } else {
        onLimitChange(value);
      }
    } else if (e.target.value === '') {
      onLimitChange(10);
    }
  };

  return (
    <div className="page-limit-selector form-item">
      {/*<h4 className="form-item__label">Pagination</h4>*/}

      <div className="claro-details">
        <div className="claro-details__wrapper">
          <div className="page-limit-inputs-row">
            <div className="form-item" style={{ flex: '1', marginRight: '4px', marginBottom: '0' }}>
              <label className="form-item__label" htmlFor="page-input">Page</label>
              <input
                id="page-input"
                className="form-element"
                type="number"
                value={page}
                onChange={handlePageChange}
                min="0"
                data-testid="page-offset-input"
              />
            </div>

            <div className="form-item" style={{ flex: '1', marginBottom: '0' }}>
              <label className="form-item__label" htmlFor="limit-input">
                Limit
                <span className="field-tooltip-wrapper js-tooltip"
                  data-tooltip="Maximum results per page (max: 50)"
                  style={{ marginLeft: '4px', cursor: 'help', display: 'inline-flex' }}>
                  <span style={{
                    display: 'inline-flex',
                    alignItems: 'center',
                    justifyContent: 'center',
                    width: '16px',
                    height: '16px',
                    borderRadius: '50%',
                    background: 'var(--gin-color-primary-light)',
                    color: 'var(--gin-color-primary)',
                    fontSize: '12px',
                    fontWeight: 'bold'
                  }}>?</span>
                </span>
              </label>
              <input
                id="limit-input"
                className="form-element"
                type="number"
                value={limit}
                onChange={handleLimitChange}
                min="1"
                max="50"
                title="Maximum value is 50"
                data-testid="page-limit-input"
              />
            </div>
          </div>

          {limit === 50 && (
            <div className="messages messages--info">
              50 is the maximum allowed page limit
            </div>
          )}

          <div className="form-item__description">
            Showing items {page * limit} to {page * limit + limit}
            <br />
            <span style={{ fontSize: '0.85em', color: '#666' }}>
              <strong>Note:</strong> Maximum limit is 50 items per page
            </span>
          </div>
        </div>
      </div>
    </div>
  );
}

export default PageLimitSelector;
