import React from 'react';
import ExplorerLayout from './ExplorerLayout.jsx';
import AuthenticationTab from './AuthenticationTab.jsx';
import ExamplesTab from './ExamplesTab.jsx';

const TabNavigation = ({
  activeTab,
  setActiveTab,
  // Explorer layout props
  explorerLayoutProps,
  // Examples tab props
  expandedExample,
  setExpandedExample,
  copyToClipboard,
  baseUrl
}) => {
  const renderTabPanel = (index) => {
    switch (index) {
      case 0:
        return <ExplorerLayout {...explorerLayoutProps} />;

      case 1:
        return <AuthenticationTab />;

      case 2:
        return (
          <ExamplesTab
            baseUrl={baseUrl}
            expandedExample={expandedExample}
            setExpandedExample={setExpandedExample}
            copyToClipboard={copyToClipboard}
          />
        );

      default:
        return null;
    }
  };

  return (
    <>
      <nav className="tabs-wrapper is-horizontal is-collapsible" role="navigation" aria-labelledby="primary-tabs-title">
        <h2 className="visually-hidden" id="primary-tabs-title">Primary tabs</h2>
        <ul className="tabs primary">
          <li className={`tabs__tab ${activeTab === 0 ? 'is-active' : ''}`}>
            <button
              className="tabs__link"
              role="tab"
              aria-selected={activeTab === 0 ? 'true' : 'false'}
              onClick={() => setActiveTab(0)}
              data-tab="builder"
            >
              Query builder
            </button>
          </li>
          <li className={`tabs__tab ${activeTab === 1 ? 'is-active' : ''}`}>
            <button
              className="tabs__link"
              role="tab"
              aria-selected={activeTab === 1 ? 'true' : 'false'}
              onClick={() => setActiveTab(1)}
              data-tab="auth"
            >
              Authentication
            </button>
          </li>
          <li className={`tabs__tab ${activeTab === 2 ? 'is-active' : ''}`}>
            <button
              className="tabs__link"
              role="tab"
              aria-selected={activeTab === 2 ? 'true' : 'false'}
              onClick={() => setActiveTab(2)}
              data-tab="code-examples"
            >
              Examples
            </button>
          </li>
        </ul>
      </nav>

      <div className="tabs__content">
        {renderTabPanel(activeTab)}
      </div>
    </>
  );
};

export default TabNavigation;
