/**
 * Copies text to clipboard and invokes a notification callback
 *
 * @param {string} text - The text to copy
 * @param {Function} showNotification - Notification callback function
 */
export const copyToClipboard = (text, showNotification) => {
  navigator.clipboard.writeText(text).then(() => {
    showNotification('Copied to clipboard!', 'success');
  }).catch(err => {
    showNotification('Failed to copy: ' + err, 'error');
  });
};
