# GitHub Copilot instructions for JSON:API Query Builder
[//]: # (https://copilot-instructions.md/)

## Project overview

See [`README.md`](../README.md) for detailed information about the module.

## General requirements

- Target Drupal 11. Avoid obsolete APIs, especially from Drupal 7.
- Only change existing code, comments, style, or formatting if directly relevant to the task.
- Call out unused code, variables, and files.
- Keep code as simple as possible; avoid clever or convoluted solutions.
- When suggesting large or architectural changes, request relevant context or documentation if not already provided.

## Code quality priorities

Emphasize code quality attributes in this order:

- **Correctness**: Ensure the code works as intended and meets the requirements.
- **Maintainability**: Write code that is easy to read, understand, and modify. This includes:
  - **Readability**: Use clear and descriptive names for variables, functions, and classes. Keep methods short and focused.
  - **Idiomaticity**: Follow established patterns and conventions for Drupal, PHP, React, and plain JavaScript.
  - **Simplicity**: Keep the code simple and avoid unnecessary complexity.
  - **Testability**: Write code that is easy to test, with clear separation of concerns.
- **Security**: Ensure the code is secure and follows best practices to prevent vulnerabilities.
- **Performance**: Consider performance, but only after other quality attributes, and avoid premature optimization.
- **Logging & debugging**: Use logging judiciously—not too much, not too little.
- **Documentation**: Write clear and concise documentation for the code, including comments and README files.

## File naming conventions

File naming conventions for new files:

- Drupal files: use standard Drupal naming conventions.
- JavaScript files in `js/react-app/src`:
  - Use camelCase for module filenames, e.g., utilities, hooks, non-component logic.
  - Use PascalCase for React component filenames.
  - Top-level files in `src/` do not follow a consistent convention; prefer the convention of similar files if adding new ones.
- Documentation files, e.g., `README.md`, `CONTRIBUTING.md`: use uppercase letters and hyphens.
- If no clear convention exists, default to the convention used by files in the same directory.

## User interface and content standards

- Follow Drupal’s user interface standards for [Interface text](https://www.drupal.org/docs/develop/user-interface-standards/interface-text).
- Follow Drupal’s content style guide for [Punctuation](https://www.drupal.org/drupalorg/style-guide/content#punctuation), especially [Titles and headings](https://www.drupal.org/drupalorg/style-guide/content#headings): "All main headings and subheadings use sentence caps: only the first letter of the first word is capitalized. Everything else except proper names is in lower case".

## Documentation standards

- **Code-level documentation:**
  - Follow Drupal's [documentation standards](https://www.drupal.org/docs/develop/standards/api-documentation-and-comment-standards) for commenting code.
  - Document all public APIs, including parameters, return values, and exceptions.
  - Make code self-documenting with descriptive variable and function names.
  - Document both what the code does and why it does it (rationale behind design decisions).

- **Documentation organization:**
  - Write clear and concise documentation for the code.
  - Keep documentation up to date when changing code.
  - Focus on explaining complex or non-obvious aspects of the code.

## Considerations when suggesting changes

When suggesting changes to code, ensure the following:

- Suggest any related documentation updates that may be required (e.g., README, API docs, usage examples).
- Suggest updates to `copilot-instructions.md` if the change affects these instructions. When updating this file, prioritize value to GitHub Copilot first, and then value and readability for human developers.
