# Installation and Testing Instructions for JSON:API Query Builder

This document provides detailed instructions for installing and testing the JSON:API Query Builder module in different environments.

## Installing in a Drupal Site

### Prerequisites
- A working Drupal 10 or 11 installation
- Composer for dependency management
- JSON:API module enabled (core)
- OpenAPI JSON:API module installed and enabled (drupal/openapi_jsonapi)
- Node.js and NPM/Yarn (for building the React application)

### Installation Steps

1. **Using Composer (Recommended)**

   Install the module using Composer:
   ```bash
   composer require drupal/jsonapi_query_builder
   ```

2. **Manual Installation**

   If not using Composer:
   - Download the module and place it in the `modules/contrib/jsonapi_query_builder` directory
   - Install dependencies manually:
     ```bash
     composer require drupal/openapi_jsonapi
     ```
   - No additional dependencies are required beyond core modules

3. **Build the JavaScript Application**

   Navigate to the module's JS directory and run the build script:
   ```bash
   cd modules/contrib/jsonapi_query_builder/js
   ./build.sh
   ```

   This build script uses Yarn to install dependencies and build the application. Make sure Yarn is installed on your system.

4. **Enable the Module**

   Enable the module using Drush:
   ```bash
   drush en jsonapi_query_builder
   ```

   Or enable it from the Drupal admin interface at `/admin/modules`.

5. **Clear Caches**

   Clear Drupal's caches:
   ```bash
   drush cr
   ```

6. **Access the Query Builder**

   The JSON:API Query Builder should now be available at:
   `/admin/jsonapi-query-builder`

## Testing in a Development Environment

### Automated Testing

The module includes automated tests and code quality tools:

```bash
# Install dev dependencies
composer install

# Run all tests
composer test

# Run specific test suites
composer phpcs      # Coding standards
composer phpstan    # Static analysis
composer phpunit    # Unit tests
```

### Manual Testing

1. **Verify Installation**

   - Check that the module is enabled: `drush pm-list | grep jsonapi_query_builder`
   - Verify the route exists: `drush route | grep jsonapi_query_builder`

2. **Test with Real Entities**

   - Create test content in your Drupal site
   - Use the JSON:API Query Builder to explore and query your content entities
   - Verify that filtering, sorting, includes, and field selection work correctly

3. **Test React Application**

   - Verify that the React app loads properly
   - Test all UI components: entity selection, field selection, filters, etc.
   - Test responsive layouts on different screen sizes

### Using the Test Script

For developers, a test script is provided that creates a temporary Drupal environment:

```bash
# Run from Drupal root directory
php modules/contrib/jsonapi_query_builder/scripts/test-module.php
```

This script:
1. Creates a test database and Drupal environment
2. Installs required modules
3. Verifies the module can be enabled
4. Tests that routes are accessible
5. Cleans up after testing

Note: This script requires a working Drupal codebase and database connection.

## Troubleshooting

### Common Issues

1. **Module Not Found**

   Ensure the module is in the correct directory: `modules/contrib/jsonapi_query_builder`

2. **JavaScript Not Loading**

   - Check that the React app is built: `ls -la modules/contrib/jsonapi_query_builder/js/react-app/build`
   - Clear Drupal caches: `drush cr`

3. **Dependencies Missing**

   Verify that all required modules are enabled:
   ```bash
   drush pm-list --package='Web Services' --fields=display_name,path,status | grep -wE 'jsonapi|openapi_jsonapi'
   ```
   Look for output like this:
   ```
   JSON:API (jsonapi)                   core/modules/jsonapi              Enabled
   OpenAPI JSON:API (openapi_jsonapi)   modules/contrib/openapi_jsonapi   Enabled
   ```

4. **Permission Issues**

   Make sure users have the 'access jsonapi query builder' permission

### Getting Help

If you encounter issues:
1. Check the Drupal.org project page for known issues
2. Review the README.md and CONTRIBUTING.md files
3. Submit an issue on the project's Drupal.org issue queue
