#!/bin/bash

#
# NAME
#     build.sh - JSON:API Query Builder React app build script
#
# SYNOPSIS
#     build.sh
#
# DESCRIPTION
#     Builds the JSON:API Explorer React app using yarn.
#

# Exit as soon as one command returns a non-zero exit code.
set -e

cd "$(dirname "$0")/react-app"

# Check if yarn is installed
if command -v yarn &> /dev/null; then

  echo "Installing dependencies with yarn..."
  yarn install
  echo

  echo "Building React app with yarn..."
  yarn build
  echo

else
  echo "Error: Yarn is not installed. Please install yarn and try again."
  echo "Visit https://yarnpkg.com/getting-started/install for installation instructions."
  exit 1
fi

echo "Build completed!"
