/**
 * Unified Jest Configuration for JSON:API Query Builder tests.
 *
 * This configuration combines settings from both jest.config.js and
 * jest-puppeteer.config.js into a single streamlined file.
 */

module.exports = {
  // Test configuration
  testMatch: ['<rootDir>/test/e2e.test.js'], // Only run the main e2e test file
  testTimeout: 120000, // 2 minute timeout
  verbose: true, // Show test progress and details
  maxWorkers: 1, // Prevent Jest from running multiple browser instances

  // Puppeteer configuration
  preset: 'jest-puppeteer',

  // Module handling
  moduleNameMapper: {
    "\\.(css|less|sass|scss)$": "<rootDir>/__mocks__/styleMock.js",
    "\\.(gif|ttf|eot|svg|png)$": "<rootDir>/__mocks__/fileMock.js"
  },

  // Mocks and transformations
  transform: {
    "^.+\\.(js|jsx)$": "babel-jest"
  },
  transformIgnorePatterns: [
    "/node_modules/(?!react-syntax-highlighter|react-json-view).+\\.js$"
  ]
};
