// Constants for localStorage keys
export const STORAGE_KEYS = {
  REQUEST_HISTORY: 'jsonapi_qb_request_history',
  AUTH_TOKEN: 'jsonapi_qb_auth_token',
  SELECTED_ENTITY: 'jsonapi_qb_selected_entity',
  SELECTED_BUNDLE: 'jsonapi_qb_selected_bundle',
  SELECTED_FIELDS: 'jsonapi_qb_selected_fields',
  INCLUDES: 'jsonapi_qb_includes',
  FILTERS: 'jsonapi_qb_filters',
  SORTS: 'jsonapi_qb_sorts',
  PAGE: 'jsonapi_qb_page',
  LIMIT: 'jsonapi_qb_limit',
  PANEL_LAYOUT: 'jsonapi_qb_panel_layout',
  AUTO_EXECUTE: 'jsonapi_qb_auto_execute'
};

// Helper to safely interact with localStorage
export const storage = {
  get: (key, defaultValue = null) => {
    try {
      const item = localStorage.getItem(key);
      return item ? JSON.parse(item) : defaultValue;
    } catch (error) {
      console.error(`Error retrieving ${key} from localStorage:`, error);
      return defaultValue;
    }
  },
  set: (key, value) => {
    try {
      localStorage.setItem(key, JSON.stringify(value));
      return true;
    } catch (error) {
      console.error(`Error storing ${key} in localStorage:`, error);
      return false;
    }
  }
};
