<?php

declare(strict_types=1);

namespace Drupal\jsonrpc_core\Plugin\jsonrpc\Method;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\jsonrpc\Attribute\JsonRpcMethod;
use Drupal\jsonrpc\Attribute\JsonRpcParameterDefinition;
use Drupal\jsonrpc\JsonRpcObject\ParameterBag;
use Drupal\jsonrpc\ParameterFactory\PaginationParameterFactory;

/**
 * RPC method to list all the permissions.
 *
 * @JsonRpcMethod(
 *   id = "user_permissions.list",
 *   usage = @Translation("List all the permissions available in the site."),
 *   access = {"administer permissions"},
 *   params = {
 *     "page" = @JsonRpcParameterDefinition(factory = "\Drupal\jsonrpc\ParameterFactory\PaginationParameterFactory"),
 *   }
 * )
 */
#[JsonRpcMethod(
  id: "user_permissions.list",
  usage: new TranslatableMarkup("List all the permissions available in the site."),
  access: ["administer permissions"],
  params: [
    'page' => new JsonRpcParameterDefinition(
      'page',
      NULL,
      PaginationParameterFactory::class,
    ),
  ]
)]
class ListPermissions extends UserPermissionsBase {

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function execute(ParameterBag $params): array {
    $page = $params->get('page');
    return array_slice(
      $this->permissions->getPermissions(),
      $page['offset'],
      $page['limit']
    );
  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public static function outputSchema(): array {
    // @todo Fix the schema.
    return ['type' => 'foo'];
  }

}
