<?php

declare(strict_types=1);

namespace Drupal\jsonrpc;

use Drupal\jsonrpc\JsonRpcObject\ParameterBag;

/**
 * Add to methods that can be executed with params.
 */
interface ExecutableWithParamsInterface {

  /**
   * Executes the action with the parameters passed in.
   *
   * @param \Drupal\jsonrpc\JsonRpcObject\ParameterBag $params
   *   The parameters.
   *
   * @return mixed
   *   The result of the execution.
   */
  public function execute(ParameterBag $params): mixed;

}
