<?php

namespace Drupal\keepeek\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a Dynameek Image Effect annotation object.
 *
 * @see \Drupal\keepeek\DynameekImageEffectInterface
 * @see \Drupal\keepeek\DynameekImageEffectPluginBase
 * @see \Drupal\keepeek\DynameekImageEffectPluginManager
 * @see plugin_api
 *
 * @Annotation
 */
class DynameekImageEffect extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $title;

  /**
   * The description of the plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description;

}
