<?php

namespace Drupal\keepeek\Plugin\DynameekImageEffect;

/**
 * Plugin implementation of the 'Focal Point Scale and Crop' Dynameek Image Effect.
 *
 * @DynameekImageEffect(
 *   id = "focal_point_scale_and_crop",
 *   label = @Translation("Focal Point Scale and Crop"),
 *   description = @Translation("A bridge from the 'Focal Point Scale and Crop' image effect to the Dynameek 'Crop' action.")
 * )
 *
 * @see \Drupal\focal_point\Plugin\ImageEffect\FocalPointScaleAndCropImageEffect
 */
class FocalPointScaleAndCropImageEffect extends FocalPointCropImageEffect {

  /**
   * {@inheritdoc}
   */
  public function transform($url, $json) {
    $result = parent::transform($url, $json);

    // TODO: Count crop width/height based on image dimensions ratio.
    $result['parameters']['el'] = 'true';
    $result['parameters']['ex'] = 'false';

    return $result;
  }

}
