<?php

namespace Drupal\keepeek;

/**
 * Defines the interface for Dynameek Image Effect plugins.
 *
 * @see \Drupal\keepeek\Annotation\DynameekImageEffect
 * @see \Drupal\keepeek\DynameekImageEffectPluginBase
 * @see \Drupal\keepeek\DynameekImageEffectPluginManager
 * @see plugin_api
 */
interface DynameekImageEffectInterface {

  /**
   * Transform asset data to Dynameek effect.
   *
   * @param string $url
   *   The asset URL.
   * @param object $json
   *   The asset metadata.
   *
   * @return array
   *   The transformed action or NULL if not supported.
   */
  public function transform($url, $json);

}
