<?php

namespace Drupal\keepeek;

use Drupal\Component\Plugin\PluginBase;

/**
 * Provides a base implementation for Dynameek Image Effect plugins.
 *
 * @see \Drupal\keepeek\Annotation\DynameekImageEffect
 * @see \Drupal\keepeek\DynameekImageEffectInterface
 * @see \Drupal\keepeek\DynameekImageEffectPluginManager
 * @see plugin_api
 */
abstract class DynameekImageEffectPluginBase extends PluginBase implements DynameekImageEffectInterface {

  /**
   * {@inheritdoc}
   */
  public function transform($url, $json) {
    return [
      'action' => '',
      'parameters' => [
        'src' => $json->imagesServicePermalinks,
      ],
    ];
  }

}
