<?php

namespace Drupal\keepeek\Plugin\DynameekImageEffect;

/**
 * Plugin implementation of the 'Focal Point Crop by Width' Dynameek Image Effect.
 *
 * @DynameekImageEffect(
 *   id = "focal_point_crop_by_width",
 *   label = @Translation("Focal Point Crop by Width"),
 *   description = @Translation("A bridge from the 'Focal Point Crop by Width' image effect to the Dynameek 'Crop' action.")
 * )
 *
 * @see \Drupal\focal_point\Plugin\ImageEffect\FocalPointCropByWidthImageEffect
 */
class FocalPointCropByWidthImageEffect extends FocalPointCropImageEffect {

  /**
   * {@inheritdoc}
   */
  public function transform($url, $json) {
    $result = parent::transform($url, $json);

    if (!empty($this->configuration['width'])) {
      $result['parameters']['ch'] = $this->configuration['width'];
      unset($result['parameters']['w']);
    }

    return $result;
  }

}
