<?php

namespace Drupal\Tests\keepeek\Kernel;

use Drupal\Core\Entity\Entity\EntityViewDisplay;
use Drupal\Core\Form\FormState;
use Drupal\field\Entity\FieldConfig;
use Drupal\field\Entity\FieldStorageConfig;
use Drupal\keepeek\Form\KeepeekMediaForm;
use Drupal\keepeek\Plugin\Field\FieldFormatter\KeepeekFormatterBase;
use Drupal\KernelTests\KernelTestBase;
use Drupal\media_library\MediaLibraryState;
use Drupal\Tests\media\Traits\MediaTypeCreationTrait;

/**
 * Test Keepeek media form.
 *
 * @covers \Drupal\keepeek\Form\KeepeekMediaForm
 * @group keepeek
 */
class KeepeekMediaFormTest extends KernelTestBase {

  use MediaTypeCreationTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'field',
    'file',
    'filter',
    'image',
    'keepeek',
    'media',
    'media_library',
    'user',
    'views',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('media');

    $this->createMediaType('keepeek', [
      'id' => 'keepeek',
      'field_map' => ['json' => 'field_media_keepeek_1_json'],
    ]);
    FieldStorageConfig::create([
      'field_name' => 'field_media_keepeek_1_json',
      'entity_type' => 'media',
      'type' => 'string_long',
    ])->save();
    FieldConfig::create([
      'field_name' => 'field_media_keepeek_1_json',
      'entity_type' => 'media',
      'bundle' => 'keepeek',
    ])->save();
    EntityViewDisplay::create([
      'targetEntityType' => 'media',
      'bundle' => 'keepeek',
      'mode' => 'default',
    ])->setComponent('field_media_keepeek', [
      'type' => 'keepeek',
      'settings' => [
        'formatter_class' => KeepeekFormatterBase::class,
      ],
    ])->save();
  }

  /**
   * Tests that submitted values are processed and saved correctly.
   */
  public function testSubmitForm() {
    $form_state = new FormState();
    $media_library_state = MediaLibraryState::create('test', ['keepeek'], 'keepeek', -1);
    $form_state->setStorage([
      'media_library_state' => $media_library_state,
    ]);
    $form_state->setValues([
      'url' => 'https://assets-iconeek.keepeek.com/pm_12799_15_15886-3he1dvuc8i-whr.jpg',
      'json' => '{"id":15886,"title":{"id":"title","type":"TEXT","name":"Title","value":"zachary-shea-MAFUZ8Nh7XQ-unsplash","descriptionByValue":{}}}',
      'current_selection' => '',
    ]);

    /** @var \Drupal\keepeek\Form\KeepeekMediaForm $form */
    $form = $this->container->get('class_resolver')
      ->getInstanceFromDefinition(KeepeekMediaForm::class);
    $form->addButtonSubmit([], $form_state);

    $media = $form_state->get('media');
    $this->assertNotEmpty($media);
    $this->assertEquals('zachary-shea-MAFUZ8Nh7XQ-unsplash', $media[0]->getName());
    $this->assertEquals('https://assets-iconeek.keepeek.com/pm_12799_15_15886-3he1dvuc8i-whr.jpg', $media[0]->get('field_media_keepeek')->value);
  }

}
