<?php

namespace Drupal\keepeek\Plugin\DynameekImageEffect;

use Drupal\keepeek\DynameekImageEffectPluginBase;

/**
 * Plugin implementation of the 'Focal Point Crop' Dynameek Image Effect.
 *
 * @DynameekImageEffect(
 *   id = "focal_point_crop",
 *   label = @Translation("Focal Point Crop"),
 *   description = @Translation("A bridge from the 'Focal Point Crop' image effect to the Dynameek 'Crop' action.")
 * )
 *
 * @see \Drupal\focal_point\Plugin\ImageEffect\FocalPointCropImageEffect
 */
class FocalPointCropImageEffect extends DynameekImageEffectPluginBase {

  /**
   * {@inheritdoc}
   */
  public function transform($url, $json) {
    $result = parent::transform($url, $json);

    $result['action'] = 'crop';

    if (isset($json->pointOfInterest->x)) {
      $result['parameters']['poiX'] = $json->pointOfInterest->x;
    }
    if (isset($json->pointOfInterest->y)) {
      $result['parameters']['poiY'] = $json->pointOfInterest->y;
    }
    if (!empty($this->configuration['width'])) {
      $result['parameters']['cw'] = $this->configuration['width'];
      $result['parameters']['w'] = $this->configuration['width'];
    }
    if (!empty($this->configuration['height'])) {
      $result['parameters']['ch'] = $this->configuration['height'];
      $result['parameters']['h'] = $this->configuration['height'];
    }
    $result['parameters']['el'] = 'false';
    $result['parameters']['ex'] = 'true';

    return $result;
  }

}
