<?php

namespace Drupal\keepeek\Plugin\DynameekImageEffect;

use Drupal\keepeek\DynameekImageEffectPluginBase;

/**
 * Plugin implementation of the 'Resize' Dynameek Image Effect.
 *
 * @DynameekImageEffect(
 *   id = "image_resize",
 *   label = @Translation("Resize"),
 *   description = @Translation("A bridge from the 'Resize' image effect to the Dynameek 'Resize' action.")
 * )
 *
 * @see \Drupal\image\Plugin\ImageEffect\ResizeImageEffect
 */
class ResizeImageEffect extends DynameekImageEffectPluginBase {

  /**
   * {@inheritdoc}
   */
  public function transform($url, $json) {
    $result = parent::transform($url, $json);

    $result['action'] = 'resize';

    if (!empty($this->configuration['width'])) {
      $result['parameters']['w'] = $this->configuration['width'];
    }
    if (!empty($this->configuration['height'])) {
      $result['parameters']['h'] = $this->configuration['height'];
    }
    if (isset($json->pointOfInterest->x)) {
      $result['parameters']['poiX'] = $json->pointOfInterest->x;
    }
    if (isset($json->pointOfInterest->y)) {
      $result['parameters']['poiY'] = $json->pointOfInterest->y;
    }
    $result['parameters']['el'] = 'true';
    $result['parameters']['t'] = 'force';

    return $result;
  }

}
