<?php

namespace Drupal\keepeek\Plugin\DynameekImageEffect;

/**
 * Plugin implementation of the 'Scale' Dynameek Image Effect.
 *
 * @DynameekImageEffect(
 *   id = "image_scale",
 *   label = @Translation("Scale"),
 *   description = @Translation("A bridge from the 'Scale' image effect to the Dynameek 'Resize' action.")
 * )
 *
 * @see \Drupal\image\Plugin\ImageEffect\ScaleImageEffect
 */
class ScaleImageEffect extends ResizeImageEffect {

  /**
   * {@inheritdoc}
   */
  public function transform($url, $json) {
    $result = parent::transform($url, $json);

    if (empty($this->configuration['upscale'])) {
      $result['parameters']['el'] = 'false';
    }
    $result['parameters']['t'] = 'fit';

    return $result;
  }

}
