<?php

namespace Drupal\keepeek\Event;

use Drupal\media\MediaInterface;
use Symfony\Contracts\EventDispatcher\Event;

class KeepeekMediaNameResolveEvent extends Event
{
  /**
   * @var string $name
   *   The resolved name.
   */
  protected $name;

  /**
   * @var array $sourceConfiguration
   *   The media source configuration.
   */
  protected $sourceConfiguration;

  /**
   * @var MediaInterface $media
   *   The media entity.
   */
  protected $media;

  /**
   * @var array|null $keepeekData
   *   The keepeek json data.
   */
  protected $keepeekData;

  /**
   * The event constructor.
   *
   * @param string $name
   * @param array $sourceConfiguration
   * @param MediaInterface $media
   * @param array|null $keepeekData
   */
  public function __construct(string $name, array $sourceConfiguration, MediaInterface $media, ?array $keepeekData) {
    $this->name = $name;
    $this->sourceConfiguration = $sourceConfiguration;
    $this->media = $media;
    $this->keepeekData = $keepeekData;
  }

  /**
   * Get the media source configuration.
   *
   * @return array
   *   The media source configuration.
   */
  public function getSourceConfiguration(): array {
    return $this->sourceConfiguration;
  }

  /**
   * Get the Media entity.
   *
   * @return MediaInterface
   *   The media entity.
   */
  public function getMedia(): MediaInterface {
    return $this->media;
  }

  /**
   * Get the keepeek data.
   *
   * @return array|null
   *   The keepeek data extracted from json field.
   */
  public function getKeepeekData(): ?array {
    return $this->keepeekData;
  }

  /**
   * Get the current name.
   *
   * @return string
   *   The current name.
   */
  public function getName(): string {
    return $this->name;
  }

  /**
   * Alter the current name.
   *
   * @param string $name
   * @return void
   */
  public function setName(string $name): void {
    $this->name = $name;
  }

}
