<?php

namespace Drupal\keepeek\Plugin\DynameekImageEffect;

use Drupal\keepeek\DynameekImageEffectPluginBase;

/**
 * Plugin implementation of the 'Convert' Dynameek Image Effect.
 *
 * @DynameekImageEffect(
 *   id = "image_convert",
 *   label = @Translation("Convert"),
 *   description = @Translation("A bridge from the 'Convert' image effect to the Dynameek actions.")
 * )
 *
 * @see \Drupal\image\Plugin\ImageEffect\ConvertImageEffect
 */
class ConvertImageEffect extends DynameekImageEffectPluginBase {

  /**
   * {@inheritdoc}
   */
  public function transform($url, $json) {
    $result = [];

    $mapping = [
      'jpeg' => 'jpeg',
      'jpg' => 'jpeg',
      'png' => 'png',
      'webp' => 'webp',
    ];
    if (!empty($this->configuration['extension'])
      && !empty($mapping[$this->configuration['extension']])
    ) {
      $result['parameters']['f'] = $mapping[$this->configuration['extension']];
    }

    return $result;
  }

}
