<?php

namespace Drupal\keepeek\Plugin\DynameekImageEffect;

use Drupal\keepeek\DynameekImageEffectPluginBase;

/**
 * Plugin implementation of the 'Crop' Dynameek Image Effect.
 *
 * @DynameekImageEffect(
 *   id = "image_crop",
 *   label = @Translation("Crop"),
 *   description = @Translation("A bridge from the 'Crop' image effect to the Dynameek 'Crop' action.")
 * )
 *
 * @see \Drupal\image\Plugin\ImageEffect\CropImageEffect
 */
class CropImageEffect extends DynameekImageEffectPluginBase {

  /**
   * {@inheritdoc}
   */
  public function transform($url, $json) {
    $result = parent::transform($url, $json);

    $result['action'] = 'crop';

    if (!empty($this->configuration['anchor'])) {
      [$x, $y] = explode('-', $this->configuration['anchor']);
      $anchor_mapping = [
        'top' => 0,
        'left' => 0,
        'center' => 50,
        'bottom' => 100,
        'right' => 100,
      ];
      if (isset($anchor_mapping[$x])) {
        $result['parameters']['poiX'] = $anchor_mapping[$x];
      }
      if (isset($anchor_mapping[$y])) {
        $result['parameters']['poiY'] = $anchor_mapping[$y];
      }
    }
    if (!empty($this->configuration['width'])) {
      $result['parameters']['cw'] = $this->configuration['width'];
      $result['parameters']['w'] = $this->configuration['width'];
    }
    if (!empty($this->configuration['height'])) {
      $result['parameters']['ch'] = $this->configuration['height'];
      $result['parameters']['h'] = $this->configuration['height'];
    }
    $result['parameters']['el'] = 'false';
    $result['parameters']['ex'] = 'true';

    return $result;
  }

}
