<?php

namespace Drupal\keepeek\Plugin\DynameekImageEffect;

/**
 * Plugin implementation of the 'Scale and crop' Dynameek Image Effect.
 *
 * @DynameekImageEffect(
 *   id = "image_scale_and_crop",
 *   label = @Translation("Scale and crop"),
 *   description = @Translation("A bridge from the 'Scale and crop' image effect to the Dynameek 'Crop' action.")
 * )
 *
 * @see \Drupal\image\Plugin\ImageEffect\ScaleAndCropImageEffect
 */
class ScaleAndCropImageEffect extends CropImageEffect {

  /**
   * {@inheritdoc}
   */
  public function transform($url, $json) {
    $result = parent::transform($url, $json);

    // TODO: Count crop width/height based on image dimensions ratio.
    $result['parameters']['el'] = 'true';
    $result['parameters']['ex'] = 'false';

    return $result;
  }

}
