# Kinetic Theme
Kinetic is a modern Single Directory Component (SDC) driven theme and is intended to maximize reusability, accessibility, performance and efficiency. Kinetic is a perfect starting point for theming your site.

## Installing Kinetic
1. Install the `vite` module on your site
```
composer require drupal/vite
```
2. Also install the Propel module. This provides a drush command to download SDCs from [Propel Components](https://elevatedthird.github.io/propel-components/?path=/docs/introduction--docs)
```
composer require elevatedthird/propel-drush:dev-main

drush pm:enable propel

```
3. Add the following to your settings.ddev.php
```
$settings['vite'] = [
  'devServerUrl' => 'https://[YOUR_SITE_NAME].ddev.site:5173',
  'baseUrl' => '/themes/custom/kinetic/dist/',
  'devDependencies' => [
    'kinetic/vite-client'
  ],
];
```
4. Add the following to the "autoload" property in your composer.json
```
"psr-4": {
  "Drupal\\kinetic\\": "docroot/themes/custom/kinetic/src"
}
```
## Using with Propel
Kinetic by itself does not have base styles or SDCs. There are some libraries installed in the package.json, but it's intended that you use the Propel component library.

Start by running `drush propel:init` to get teh base stylesheet andstarter SDCs

## Theme Structure
`includes` : Preprocess function
`source/01-base/assets`  : Put your static assets here
`source/01-base/core`    : IGNORE THIS, used by the base starterkit theme
`source/01-base/global`  : Global CSS and JS
`source/01-base/helpers` : Helper JS classes
`source/02-components`   : Your SDCs
`templates`              : Drupal template Overrides
`src`                    : Classes for Font preloading and Layout Builder Layout Plugins

### Configuring Tailwind
If you are NOT using Propel, run:
```
echo "@import \"tailwindcss\";" > ./source/01-base/global/css/index.pcss.css
```

Tailwind is a utility first library. It is not recommended that you add global rules to the index file.

## Local Development
You cannot have any other Lando or DDEV containers running. If you see a port number in the url, stop all the other
containers first. The port number interferes with HMR and the files will not be proxied to the dev site.

You must run Vite from inside the DDEV container. Run these commands on your host machine
```
cd docroot/themes/custom/kinetic
ddev npm install
ddev npm run dev
ddev drush cr
```

## Building
```
ddev npm run build
ddev drush cr
```

## Layout Builder Layouts
If you are using layout builder, you can define custom layouts in `kinetic.layouts.yml`. Configuration is in the /src directory

## Layout Builder improvements
If you need to add styles to Layout Builder routes dues to conflicts with the theme,
you can add them to `source/01-base/global/css/layout-builder.pcss.css`.

Kinetic includes a `kinetic/layout-builder` library that is automatically added to Layout Builder routes.

## Single Directory Components
Please read about SDCs here:https://www.drupal.org/docs/develop/theming-drupal/using-single-directory-components/about-single-directory-components

### Adding an SDC
Check if there's an SDC you can use from [Propel](https://github.com/elevatedthird/propel-components/tree/main/components). If not, continue below.

1. Create a folder in `source/02-components/`
2. Your SDC must include both a `[name].component.yml` and `[name].twig` file.
3. If your SDC needs JS, add a `[name].es6.js` file
4. If your SDC needs CSS, add a `[name].pcss.css` file.
In your file add `@reference '@base/01-base/global/css/index.pcss.css'`. This will let you use the global tailwind classes without duplicating class generation.
5. Restart the dev server. `npm run dev`
6. ddev drush cr