<?php

use Drupal\kinetic\FontPreloader;

/**
 * @file
 * page.theme
 */

/**
 * Implements hook_page_attachments_alter().
 */
function kinetic_page_attachments_alter(&$attachments) {
  // Load the font preloader class.
  $font_preloader = \Drupal::classResolver(FontPreloader::class);
  // Add fonts to page attachments.
  $font_preloader->attach($attachments);
}

/**
 * Implements hook_preprocess_page().
 * Set a variable to indicate if the current page is a layout builder page.
 */
function kinetic_preprocess_page(array &$variables) {
  $variables['is_layout_builder'] = FALSE;
  $route_name = \Drupal::routeMatch()->getRouteName();
  if ($route_name !== NULL && preg_match('/^(layout_builder\.([^.]+\.)?)/', $route_name)) {
    $variables['is_layout_builder'] = TRUE;
  }
}

/*
 * Implements hook_theme_suggestions_page_alter().
 */
function kinetic_theme_suggestions_page_alter(array &$suggestions, array $variables) {
  // Add a suggestion for the styleguide page.
  $current_path = \Drupal::service('path.current')->getPath();
  $result = \Drupal::service('path_alias.manager')->getAliasByPath($current_path);
  if ($result === '/styleguide') {
    $suggestions[] = 'page__node__' . 'styleguide';
  }
}
