<?php

namespace Drupal\kinetic;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Render\Element;

/**
 * Hero layout.
 *
 * @internal
 *   Plugin classes are internal.
 */
class KineticLayoutOneColumn extends KineticLayout {

  /**
   * {@inheritdoc}
   */
  public function build(array $regions) {
    $build = parent::build($regions);
    $build['#attributes']['class'] = [
      'layout',
      $this->getPluginDefinition()->getTemplate(),
    ];
    return $build;
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildConfigurationForm($form, $form_state);
    $form['bg_color']['#access'] = TRUE;
    $form['content_width']['#access'] = TRUE;
    $form['spacing']['#access'] = TRUE;
    return $form;

  }


}
