# Knova - AI Chatbot Widget for Drupal

**Version:** 1.0.0  
**Drupal:** 10.x, 11.x  
**License:** GPL-2.0-or-later

## Introduction

Knova is an AI-powered chatbot widget for Drupal websites. It provides a floating chat interface that helps visitors find information quickly by answering questions based on your website's content. The chatbot integrates with OpenAI's API and can be trained on your specific website data to provide accurate, context-aware responses.

## Features

- **Floating Chat Widget**: Intercom-like design that appears on your site
- **OpenAI Integration**: Supports GPT-4, GPT-3.5, and custom models
- **Custom Q&A Training**: Train the chatbot with your own question-answer pairs
- **Full Customization**: Customize colors, positioning, dimensions, and branding
- **Lead Capture**: Collect and manage inquiries from visitors
- **Multiple Storage Options**: Store conversations in localStorage, database, or session
- **Rate Limiting**: Control API costs with configurable rate limits
- **Mobile Responsive**: Works seamlessly on all devices
- **Security**: CSRF protection and security best practices
- **Block Plugin**: Flexible placement options via Drupal blocks

## Installation

1. Download and extract the module to your modules directory (`modules/custom/` or `modules/contrib/`)
2. Enable the module at `/admin/modules`
3. Configure at `/admin/config/services/knova`
4. Add your OpenAI API key
5. Train the chatbot with Q&A pairs based on your website content
6. The widget will appear automatically on your site

## Configuration

After installation, navigate to **Configuration > Services > Knova Settings** to:

- Configure your OpenAI API key and endpoint
- Set up system prompts for the AI
- Add custom Q&A pairs for training
- Customize widget appearance (colors, position, size)
- Configure conversation storage options
- Set up rate limiting
- Manage inquiries

## Requirements

- Drupal 10.x or 11.x
- PHP 7.4 or higher (PHP 8.1+ recommended)
- OpenAI API key (sign up at https://platform.openai.com/)

## Usage

### Basic Setup

1. **Get an OpenAI API Key**: Sign up at https://platform.openai.com/ and create an API key
2. **Configure Settings**: Go to `/admin/config/services/knova` and enter your API key
3. **Train Your Chatbot**: Add Q&A pairs that reflect your website's content and common questions
4. **Customize Appearance**: Adjust colors, positioning, and branding to match your site
5. **Test**: Visit your site and test the chatbot widget

### Widget Placement

The widget can be displayed in two ways:

1. **Automatic (via hook)**: The widget automatically appears on all pages (except admin pages)
2. **Block Placement**: Use the "Knova Widget" block plugin to place the widget in specific regions

### Training Your Chatbot

Add question-answer pairs that cover:
- Your services or products
- Common customer questions
- Important policies or information
- Navigation help
- Contact information

The more Q&A pairs you add, the better your chatbot will understand your website and answer questions accurately.

## Support

- **Issue Queue**: https://www.drupal.org/project/issues/knova
- **Project Page**: https://www.drupal.org/project/knova

## License

GPL-2.0-or-later

## Changelog

See `CHANGELOG.txt` for detailed version history.
