<?php

namespace Drupal\knova\Plugin\Block;

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\knova\Service\SettingsManager;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a Knova Widget Block.
 *
 * @Block(
 *   id = "knova_widget_block",
 *   admin_label = @Translation("Knova AI Chatbot Widget"),
 *   category = @Translation("Knova")
 * )
 */
class KnovaWidgetBlock extends BlockBase implements ContainerFactoryPluginInterface {

  /**
   * The settings manager.
   *
   * @var \Drupal\knova\Service\SettingsManager
   */
  protected $settingsManager;

  /**
   * Constructs a KnovaWidgetBlock object.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin_id for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param \Drupal\knova\Service\SettingsManager $settings_manager
   *   The settings manager.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, SettingsManager $settings_manager) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->settingsManager = $settings_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('knova.settings_manager')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function build() {
    $settings = $this->settingsManager->getSettings();

    // Only render if enabled
    if (!$settings['enabled']) {
      return [];
    }

    return [
      '#theme' => 'knova_widget',
      '#settings' => $settings,
      '#attached' => [
        'library' => ['knova/widget'],
      ],
      '#cache' => [
        'max-age' => 0,
        'tags' => ['config:knova.settings'],
      ],
    ];
  }

}

