<?php

namespace Drupal\knova\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\knova\Service\SettingsManager;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Widget Controller for Knova.
 */
class WidgetController extends ControllerBase {

  /**
   * The settings manager.
   *
   * @var \Drupal\knova\Service\SettingsManager
   */
  protected $settingsManager;

  /**
   * Constructs a WidgetController object.
   *
   * @param \Drupal\knova\Service\SettingsManager $settings_manager
   *   The settings manager.
   */
  public function __construct(SettingsManager $settings_manager) {
    $this->settingsManager = $settings_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('knova.settings_manager')
    );
  }

  /**
   * Render widget.
   *
   * @return array
   *   Render array.
   */
  public function render() {
    $settings = $this->settingsManager->getSettings();

    return [
      '#theme' => 'knova_widget',
      '#settings' => $settings,
      '#cache' => [
        'max-age' => 0,
      ],
    ];
  }

}

