/**
 * @file
 * Knova Admin JavaScript
 */
(function ($, Drupal) {
  'use strict';

  Drupal.behaviors.knovaAdmin = {
    attach: function (context, settings) {
      // Q&A Pairs Management
      const container = $('#knova-qa-pairs-container', context);
      if (!container.length) {
        return;
      }

      // Get initial count from existing pairs or settings
      let qaIndex = container.find('.knova-qa-pair').length;
      if (typeof drupalSettings !== 'undefined' && drupalSettings.knova_qa_pairs_count !== undefined) {
        qaIndex = Math.max(qaIndex, drupalSettings.knova_qa_pairs_count);
      }

      // Add Q&A pair - use event delegation for dynamically added buttons
      $(context).on('click', '.knova-add-qa-pair', function (e) {
        e.preventDefault();
        e.stopPropagation();
        
        // Create proper Drupal form structure
        const pairHtml = 
          '<div class="knova-qa-pair form-wrapper">' +
          '<div class="form-item form-item-ai-qa-pairs-pairs-' + qaIndex + '-question">' +
          '<label for="edit-ai-qa-pairs-pairs-' + qaIndex + '-question">Question</label>' +
          '<input type="text" id="edit-ai-qa-pairs-pairs-' + qaIndex + '-question" name="ai[qa_pairs][pairs][' + qaIndex + '][question]" value="" size="60" maxlength="255" class="form-text" />' +
          '</div>' +
          '<div class="form-item form-item-ai-qa-pairs-pairs-' + qaIndex + '-answer">' +
          '<label for="edit-ai-qa-pairs-pairs-' + qaIndex + '-answer">Answer</label>' +
          '<div class="form-textarea-wrapper">' +
          '<textarea id="edit-ai-qa-pairs-pairs-' + qaIndex + '-answer" name="ai[qa_pairs][pairs][' + qaIndex + '][answer]" rows="3" cols="60" class="form-textarea resize-vertical"></textarea>' +
          '</div>' +
          '</div>' +
          '<div class="form-item form-item-ai-qa-pairs-pairs-' + qaIndex + '-url">' +
          '<label for="edit-ai-qa-pairs-pairs-' + qaIndex + '-url">URL (optional)</label>' +
          '<input type="url" id="edit-ai-qa-pairs-pairs-' + qaIndex + '-url" name="ai[qa_pairs][pairs][' + qaIndex + '][url]" value="" size="60" maxlength="2048" class="form-url" />' +
          '<div class="description">Optional URL to include in the answer.</div>' +
          '</div>' +
          '<button type="button" class="button knova-remove-qa-pair">Remove</button>' +
          '</div>';
        
        container.append(pairHtml);
        qaIndex++;
      });

      // Remove Q&A pair - use event delegation for dynamically added buttons
      $(context).on('click', '.knova-remove-qa-pair', function (e) {
        e.preventDefault();
        e.stopPropagation();
        $(this).closest('.knova-qa-pair').remove();
        // Update index count
        qaIndex = container.find('.knova-qa-pair').length;
      });

      // Delete all Q&A pairs
      $(context).on('click', '#knova-delete-all-qa', function (e) {
        e.preventDefault();
        e.stopPropagation();
        
        if (confirm(Drupal.t('Are you sure you want to delete ALL Q&A pairs? This action cannot be undone.'))) {
          container.find('.knova-qa-pair').remove();
          qaIndex = 0;
        }
      });
    }
  };

})(jQuery, Drupal);

