<?php

namespace Drupal\kordiam\Collection;

use Drupal\Core\Link;
use Drupal\Core\Url;

/**
 * Provides a collection of translated notice messages for the Kordiam module.
 */
class NoticesCollection {

  /**
   * Getting notice message.
   *
   * @param int $code
   *   The code message.
   *
   * @return string
   *   The message text.
   */
  public static function getNotice(int $code): string {
    // Generate custom links.
    $dn_credentials_link = Link::fromTextAndUrl(\Drupal::translation()
      ->translate('Kordiam Credentials'), Url::fromUri("internal:/admin/config/kordiam/kordiam-credentials"))
      ->toString();
    $support_link = Link::fromTextAndUrl('support@kordiam.io', Url::fromUri("mailto:support@kordiam.io"))
      ->toString();

    $message_list = [
      1 => \Drupal::translation()
        ->translate('Story update successfully sent to Kordiam'),
      2 => \Drupal::translation()
        ->translate('Cannot update story in Kordiam. The Drupal module could not find a
     corresponding story ID in Kordiam. Code: 01'),
      3 => \Drupal::translation()
        ->translate('Cannot update story in Kordiam. There is no corresponding story in
     Kordiam. Code: 02'),
      4 => \Drupal::translation()
        ->translate("Cannot update the story in Kordiam. Reason unknown. Please contact
     Kordiam support at @link. Code: 03", ['@link' => $support_link]),
      5 => \Drupal::translation()
        ->translate("The Kordiam API login credentials are not valid or have not been 
     entered. Please check the settings on the page @link in the Kordiam module. Code: 04",
          ['@link' => $dn_credentials_link]),
      6 => \Drupal::translation()
        ->translate('Cannot create story in Kordiam. Reason unknown. Code: 05'),
      7 => \Drupal::translation()
        ->translate('Connection successfully established.'),
      8 => \Drupal::translation()
        ->translate('Connection could not be established.'),
      9 => \Drupal::translation()
        ->translate('There is no connection from Drupal to Kordiam. Code: 07'),
      10 => \Drupal::translation()
        ->translate('There is no connection from Kordiam to Drupal. Code: 08'),
      11 => \Drupal::translation()
        ->translate("Cannot create story in Kordiam. Publication date doesn't match platform schedule."),
      12 => \Drupal::translation()
        ->translate("Cannot update story in Kordiam. Publication date doesn't match platform schedule."),
      13 => \Drupal::translation()
        ->translate('The configuration options have been saved.'),
    ];

    return $message_list[$code];
  }

}
