<?php

namespace Drupal\kordiam\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Url;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Provides route responses for the Example module.
 */
class GenerateDrupalCredentialsController extends ControllerBase {

  /**
   * The generate new API credentials.
   */
  public static function generateApiCredentials() {
    // Generate a unique ID.
    $kordiam_api_key = str_replace('.', '', uniqid('api_', TRUE));
    $kordiam_api_secret = str_replace('.', '', uniqid('', TRUE));

    // Generate new clients.
    \Drupal::configFactory()
      ->getEditable('kordiam.settings')
      ->set('kordiam_api_key', $kordiam_api_key)
      ->set('kordiam_api_secret', $kordiam_api_secret)
      ->save();

    return new RedirectResponse(Url::fromUserInput('/admin/config/kordiam?dn-credentials=generate')
      ->toString());
  }

}
