<?php

namespace Drupal\kordiam\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\Core\Entity\EntityInterface;

/**
 * Event fired to allow altering node revision before saving from Kordiam.
 */
class EntityUpdateByKordiamEvent extends Event {

  /**
   * The event name.
   */
  public const EVENT_NAME = 'kordiam.entity_update_by_kordiam';

  /**
   * The Drupal node being updated.
   *
   * @var \Drupal\Core\Entity\EntityInterface
   */
  protected EntityInterface $node;

  /**
   * The incoming story data from Kordiam.
   *
   * @var array
   */
  protected array $data;

  /**
   * The Kordiam revision array that will be saved (mutable).
   *
   * @var array
   */
  protected array $kordiamRevision;

  /**
   * Action label for subscribers (e.g., 'update_by_kordiam').
   *
   * @var string
   */
  protected string $action;

  /**
   * Flag to prevent saving Kordiam revision data.
   *
   * @var bool
   */
  protected bool $preventRevisionSave = FALSE;

  /**
   * Constructs the event.
   */
  public function __construct(EntityInterface $node, array $data, array $kordiam_revision, string $action) {
    $this->node = $node;
    $this->data = $data;
    $this->kordiamRevision = $kordiam_revision;
    $this->action = $action;
  }

  /**
   * Gets the node.
   */
  public function getNode(): EntityInterface {
    return $this->node;
  }

  /**
   * Gets incoming story data.
   */
  public function getData(): array {
    return $this->data;
  }

  /**
   * Gets current Kordiam revision array.
   */
  public function getKordiamRevision(): array {
    return $this->kordiamRevision;
  }

  /**
   * Replace the Kordiam revision array.
   */
  public function setKordiamRevision(array $revision): void {
    $this->kordiamRevision = $revision;
  }

  /**
   * Gets action label.
   */
  public function getAction(): string {
    return $this->action;
  }

  /**
   * Sets the flag to prevent saving Kordiam revision data.
   */
  public function setPreventRevisionSave(bool $prevent): void {
    $this->preventRevisionSave = $prevent;
  }

  /**
   * Gets the flag that prevents saving Kordiam revision data.
   */
  public function shouldPreventRevisionSave(): bool {
    return $this->preventRevisionSave;
  }
}


