<?php

namespace Drupal\kordiam\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\Core\Entity\EntityInterface;

/**
 * Event fired when story data is received from Kordiam before applying.
 *
 * Allows subscribers to alter inbound data before it updates Drupal.
 */
class IncomingStorySyncEvent extends Event {

  /**
   * The event name for incoming story sync pre-apply.
   */
  public const EVENT_NAME = 'kordiam.incoming_story_pre_apply';

  /**
   * The incoming story data from Kordiam (mutable).
   *
   * @var array
   */
  protected array $incomingStoryData;

  /**
   * The target Drupal entity if known (for updates), NULL for creates.
   *
   * @var \Drupal\Core\Entity\EntityInterface|null
   */
  protected ?EntityInterface $entity;

  /**
   * Constructs the event.
   */
  public function __construct(array $incoming_story_data, ?EntityInterface $entity = NULL) {
    $this->incomingStoryData = $incoming_story_data;
    $this->entity = $entity;
  }

  /**
   * Gets the incoming story data.
   */
  public function getIncomingStoryData(): array {
    return $this->incomingStoryData;
  }

  /**
   * Replaces the incoming story data.
   */
  public function setIncomingStoryData(array $incoming_story_data): void {
    $this->incomingStoryData = $incoming_story_data;
  }

  /**
   * Gets the target Drupal entity if known.
   */
  public function getEntity(): ?EntityInterface {
    return $this->entity;
  }
}



