<?php

namespace Drupal\kordiam\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\Core\Entity\EntityInterface;

/**
 * Event fired before story data is sent from Drupal to Kordiam.
 *
 * Allows subscribers to alter the payload that will be sent to Kordiam.
 */
class OutgoingStorySyncEvent extends Event {

  /**
   * The event name for outgoing story sync pre-send.
   */
  public const EVENT_NAME = 'kordiam.outgoing_story_pre_send';

  /**
   * The new story data that will be sent to Kordiam (mutable).
   *
   * @var array
   */
  protected array $newStoryData;

  /**
   * The original story data fetched from Kordiam (read-only context).
   *
   * @var array
   */
  protected array $originalStoryData;

  /**
   * The Drupal entity being synchronized.
   *
   * @var \Drupal\Core\Entity\EntityInterface|null
   */
  protected ?EntityInterface $entity;

  /**
   * The Drupal content type of the entity.
   *
   * @var string|null
   */
  protected ?string $contentType;

  /**
   * Constructs the event.
   */
  public function __construct(array $new_story_data, array $original_story_data, ?EntityInterface $entity = NULL, ?string $content_type = NULL) {
    $this->newStoryData = $new_story_data;
    $this->originalStoryData = $original_story_data;
    $this->entity = $entity;
    $this->contentType = $content_type;
  }

  /**
   * Gets the story data that will be sent to Kordiam.
   */
  public function getNewStoryData(): array {
    return $this->newStoryData;
  }

  /**
   * Replaces the story data that will be sent to Kordiam.
   */
  public function setNewStoryData(array $new_story_data): void {
    $this->newStoryData = $new_story_data;
  }

  /**
   * Gets the original story data fetched from Kordiam.
   */
  public function getOriginalStoryData(): array {
    return $this->originalStoryData;
  }

  /**
   * Gets the Drupal entity being synchronized.
   */
  public function getEntity(): ?EntityInterface {
    return $this->entity;
  }

  /**
   * Gets the entity content type.
   */
  public function getContentType(): ?string {
    return $this->contentType;
  }
}



