KPLATFORMS
==========

This document describes building platforms using the kplatforms stub makefiles.
To understand how these makefiles are maintained, please see MAINTENANCE.md.


USAGE
-----

For simplicity, we use the stubs/Drupal7.make makefile in our examples. Obvi-
ously, replace this with whichever platform stub makefile is appropriate.


Build a platform
----------------

Building platform (also referred to as a code-base), we use Drush make along
with our lockfiles. A lockfile is simply a type of makefile generated by Drush,
that specifies all the versions for all the included projects.

In order to be able to build the same platform in a repeatable fashion, we use
lockfiles, since they are fully specified. Also, this allows us to build plat-
forms using the lockfiles remotely, without having to be concerned with any
includes being specified locally. For example, we can use the raw output of a
git repository containing such a lockfile, and be confident that the platform
that is built will be identical to one built right after that commit.

We start by simply calling Drush make (usually as the 'aegir' user):

    $ drush make ~/makefiles/kplatforms/lockfiles/Drupal7.lock
     ~/platforms/Drupal7_2014-07-09

We can then make any manual alterations to the platform that might be required.
For example, copying a favicon, makefile and release notes into the platform.


Import a platform
-----------------

Assuming that the platform build worked, we need to tell Aegir about it. The
easiest way to do that is to visit /node/add/platform on the Aegir site. We
then need to provide a name, such as Drupal7_2014-07-09, and specify the path
where we built it.

This can also be accomplished at the command-line by running the provision-save
and hosting-import Drush commands provided by Aegir. However, this is a very
advanced technique which we will not cover here. Use the '--help' option with
these commands to see how they work.
