# Set up

You will need [ddev](https://ddev.com/get-started/) to work on the project or start a new association site.

## Short version

Set up the project on your local machine from scratch.
**You might lose existing work if you already have it**.
```
./local-setup.sh
```

## Long version

### Bring the code

Bring the latest code from the default branch:
```
git checkout 1.0.x
git pull
ddev config --docroot=docroot --project-type=drupal
ddev start
ddev composer install
ddev drush si --existing-config
```

### Bring _just_ the latest changes to my local copy

Just pull the latest version of the code and apply it to your copy.
```
git checkout 1.0.x
git pull
ddev composer install
ddev drush deploy
```

### Getting stagting content from staging.drupal.eu

There is a gitlab job create-db-snapshot that creates a snapshot of the staging environment. You can download this and add it to the site if you like.

For development purposes we have default content in the   
installation, therefor you do not depend on a database dump.

---

## How was the first installation done

The following was done during the first set up and is no longer needed.

Some of the installation steps were taken from here:
[#3404467](https://www.drupal.org/project/la_eu/issues/3404467).

It was done via drush, like this:
```
ddev drush si -y --account-name=admin --account-pass=admin
ddev drush en -y la_eu_default_content
ddev drush pmu -y default_content
ddev launch
```
