<?php

namespace Drupal\landingi_landing_pages\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class LandingiSettingsForm extends ConfigFormBase {

  public const CONFIG_NAME = 'landingi_landing_pages.settings';

  public function getFormId(): string {
    return 'landingi_landing_pages_settings_form';
  }

  protected function getEditableConfigNames(): array {
    return [self::CONFIG_NAME];
  }

  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config(self::CONFIG_NAME);

    $form['api_token'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Landingi API Token'),
      '#default_value' => $config->get('api_token') ?: '',
      '#required' => TRUE,
      '#description' => $this->t('Enter API Token from your Landingi account.'),
    ];

    return parent::buildForm($form, $form_state);
  }

  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->configFactory->getEditable(self::CONFIG_NAME)
      ->set('api_token', $form_state->getValue('api_token'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
